
/* server.cc */

#include "test.h" // generated header file 
#include <rpc/pmap_clnt.h> // function pmap_unset

#include <cassert>
#include <string>
#include <iostream>
using namespace std;

extern "C" void test_program_4 (svc_req * rqstp, register SVCXPRT * transp);

void start_server ()
{
   SVCXPRT * transp;

   pmap_unset (TEST_PROGRAM, TEST_VERSION);

   transp = svcudp_create (RPC_ANYSOCK);
   if (transp == NULL)
   {
      cerr << "cannot create udp service" << endl;
      return;
   }

   if (! svc_register (transp, TEST_PROGRAM, TEST_VERSION, test_program_4, IPPROTO_UDP))
   {
      cerr << "unable to register udp service";
      return;
   }

   transp = svctcp_create (RPC_ANYSOCK, 0, 0);
   if (transp == NULL)
   {
      cerr << "cannot create tcp service" << endl;
      return;
   }

   if (! svc_register (transp, TEST_PROGRAM, TEST_VERSION, test_program_4, IPPROTO_TCP))
   {
      cerr << "unable to register tcp service";
      return;
   }

   svc_run ();
}

/* implementation */

void func_send (int value)
{
   cout << "Received call: send (" <<  value << ')' << endl;
}
   
double func_add (double x, double y)
{
   cout << "Received call: add (" << x << ", " << y  << ')' << endl;
   return 2*x + 3*y;
}
   
void func_hello (char * s)
{
   cout << "Received call: hello (" << s << ')' << endl;
}
   
char * func_repeat (char * s)
{
   cout << "Received call: repeat (" << s << ')' << endl;
   string t = s;
   t = t + " and " + t;
   return strdup (t.c_str ());
}
   
void func_table (int * array, int len)
{
   cout << "Received call: table ( ";
   for (int i = 0 ; i < len ; i++)
      cout << array [i] << " ";
   cout << ')' << endl;
}

/* function stubs */

void * test_send_4_svc (int value, svc_req * request)
{
   static char * result;
   func_send (value);
   return static_cast <void *> (& result);
}

double * test_add_4_svc (double x, double y, svc_req * request)
{
	static double result;
	result = func_add (x, y);
	return & result;
}

void * test_hello_4_svc (char * value, svc_req * request)
{
	static char * result;
	func_hello (value);	 
	return (void *) &result;
}

char * * test_repeat_4_svc (char * value, svc_req * request)
{
	static char * result;
	result = func_repeat (value);
	return & result;
}

void * test_table_4_svc (sequence_t data, svc_req * request)
{
	static char * result;
	func_table (data.sequence_t_val, data.sequence_t_len);
	return (void *) &result;
}

/* main */

int main (int argc, char * argv [])
{
   start_server ();
   // start_another_server ();
}

