
/* client.cc */

#include "test.h" // generated header file 

#include <cassert>
#include <string>
#include <iostream>
using namespace std;

/* start / stop */

static CLIENT * ifc = NULL;

void start_client (const string host)
{
   ifc = clnt_create (host.c_str (), TEST_PROGRAM, TEST_VERSION, "udp");
   
   if (ifc == NULL)
      clnt_pcreateerror (host.c_str ());
}

void stop_client ()
{
   if (ifc != NULL)
      clnt_destroy (ifc);
}

/* call functions */

void call_send (int n)
{
   void * response;
   assert (ifc != NULL);
   response = test_send_4 (n, ifc);
   if (response == NULL)
      clnt_perror (ifc, "Error calling function test_send");
}

double call_add (double x, double y)
{
   double * response;
   
   assert (ifc != NULL);
   response = test_add_4 (x, y, ifc);

   if (response == NULL)
      clnt_perror (ifc, "Error calling function test_add");
      
   return response == NULL ? 0 : *response;
}


void call_hello (string s)
{
   char * c = strdup (s.c_str ());	
   void * response;
   assert (ifc != NULL);
   response = test_hello_4 (c, ifc);
   if (response == NULL)
      clnt_perror (ifc, "Error calling function test_hello");
}

string call_repeat (string s)
{
   char * c = strdup (s.c_str ());	
   char * * response;
   assert (ifc != NULL);
   response = test_repeat_4 (c, ifc);
   if (response == NULL)
      clnt_perror (ifc, "Error calling function test_repeat");
   return response == NULL ? "" : *response;
}

void call_table (int * array, int len)
{
   sequence_t data;
   data.sequence_t_val = array;
   data.sequence_t_len = len;
	
   void * response;
   assert (ifc != NULL);
   response = test_table_4 (data, ifc);
   if (response == NULL)
      clnt_perror (ifc, "Error calling function test_table");
}

/* main */

int main (int argc, char * argv [])
{
   start_client ("localhost");
   
   cout << "client started" << endl;

   call_send (7);
   
   double z = call_add (1, 2);
   cout << "result from call_add is " << z << endl;
   
   call_hello (string ("from ") + argv[0]);
   
   string s = call_repeat ("abc");
   cout << "result from call_repeat is " << s << endl;
   
   int a [ ] = { 1, 2, 20, 40 };
   call_table (a, 4);
   
   stop_client ();
   cout << "client finished" << endl;
}
